#!/bin/bash
#
# detectdevices.sh
#
# Usage: devicefile.sh <device file> <temp file> <log file>
#
# Return Codes:
#
# Module History:
#  00  12/28/2004  P. Provost  Initial release

PARMS=$1
TEMPFILE=$2
LOGFILE=$3

echo "-> detectdevices.sh" >> $LOGFILE
echo "Detecting media devices for `date`" >> $LOGFILE
echo "" >> $LOGFILE

actzTrace "XMDA   T: -> detectdevices.sh"
actzTrace "XMDA   F: Checking for $DEVICE devices at `date`"

# run the SUSE hwinfo command and pass it the appropriate parameters 
if /usr/sbin/hwinfo $PARMS > $TEMPFILE; then
    
    # copy the output of the hwinfo command to the log file
    cat $TEMPFILE >> $LOGFILE
    
    actzTrace "XMDA   T: <- detectdevices.sh"
    
    echo "" >> $LOGFILE
    echo "<- detectdevices.sh" >> $LOGFILE
    echo "" >> $LOGFILE    
    exit 0

# Else the script to detect devices failed         
else
    actzTrace "XMDA   F: Error detecting devices."
    actzTrace "XMDA   T: <- detectdevices.sh"
    
    echo "Error detecting devices" >> $LOGFILE
    echo "" >> $LOGFILE
    echo "<- detectdevices.sh" >> $LOGFILE
    echo "" >> $LOGFILE
    exit 1
fi
 

